/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.debug;

import java.util.Objects;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugHook;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.function.Dispatch;
import org.squiddev.cobalt.function.LuaFunction;

public record FunctionDebugHook(LuaFunction function) implements DebugHook
{
    public FunctionDebugHook {
        Objects.requireNonNull(function, "function cannot be null");
    }

    @Override
    public boolean inheritHook() {
        return false;
    }

    @Override
    public void onCall(LuaState state, DebugState ds, DebugFrame frame) throws LuaError, UnwindThrowable {
        Dispatch.call(state, (LuaValue)this.function, (LuaValue)CALL, Constants.NIL);
    }

    @Override
    public void onReturn(LuaState state, DebugState ds, DebugFrame frame) throws LuaError, UnwindThrowable {
        Dispatch.call(state, (LuaValue)this.function, (LuaValue)RETURN, Constants.NIL);
    }

    @Override
    public void onCount(LuaState state, DebugState ds, DebugFrame frame) throws LuaError, UnwindThrowable {
        Dispatch.call(state, (LuaValue)this.function, (LuaValue)COUNT, Constants.NIL);
    }

    @Override
    public void onLine(LuaState state, DebugState ds, DebugFrame frame, int newLine) throws LuaError, UnwindThrowable {
        Dispatch.call(state, (LuaValue)this.function, (LuaValue)LINE, ValueFactory.valueOf(newLine));
    }
}

